<?php
/**
 * Advanced OpenSales, Advanced, robust set of sales modules.
 * @package Advanced OpenSales for SugarCRM
 * @copyright SalesAgility Ltd http://www.salesagility.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE
 * along with this program; if not, see http://www.gnu.org/licenses
 * or write to the Free Software Foundation,Inc., 51 Franklin Street,
 * Fifth Floor, Boston, MA 02110-1301  USA
 *
 * @author SalesAgility <info@salesagility.com>
 */

require_once('modules/AOS_Quotes/AOS_Quotes_sugar.php');
class AOS_Quotes extends AOS_Quotes_sugar {

	function __construct(){
		parent::__construct();
	}

    /**
     * @deprecated deprecated since version 7.6, PHP4 Style Constructors are deprecated and will be remove in 7.8, please update your code, use __construct instead
     */
    function AOS_Quotes(){
        $deprecatedMessage = 'PHP4 Style Constructors are deprecated and will be remove in 7.8, please update your code';
        if(isset($GLOBALS['log'])) {
            $GLOBALS['log']->deprecated($deprecatedMessage);
        }
        else {
            trigger_error($deprecatedMessage, E_USER_DEPRECATED);
        }
        self::__construct();
    }


	function save($check_notify = FALSE){
        global $sugar_config;

        if (empty($this->id)  || $this->new_with_id){
            if(isset($_POST['group_id'])) unset($_POST['group_id']);
            if(isset($_POST['product_id'])) unset($_POST['product_id']);
            if(isset($_POST['service_id'])) unset($_POST['service_id']);

            if($sugar_config['dbconfig']['db_type'] == 'mssql'){
                $this->number = $this->db->getOne("SELECT MAX(CAST(number as INT))+1 FROM aos_quotes");
            } else {
                $this->number = $this->db->getOne("SELECT MAX(CAST(number as UNSIGNED))+1 FROM aos_quotes");
            }

            if($this->number < $sugar_config['aos']['quotes']['initialNumber']){
                $this->number = $sugar_config['aos']['quotes']['initialNumber'];
            }
        }

        require_once('modules/AOS_Products_Quotes/AOS_Utils.php');

        perform_aos_save($this);

		parent::save($check_notify);

		require_once('modules/AOS_Line_Item_Groups/AOS_Line_Item_Groups.php');
		$productQuoteGroup = new AOS_Line_Item_Groups();
		$productQuoteGroup->save_groups($_POST, $this, 'group_');
	}

	function mark_deleted($id)
	{
		$productQuote = new AOS_Products_Quotes();
		$productQuote->mark_lines_deleted($this);
		parent::mark_deleted($id);
	}
}
?>
